<?php

/* --------------------------------------------------------------
   ContentOpenInNewTabStatus.inc.php 2019-04-12
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

/**
 * Class ContentOpenInNewTabStatus
 *
 * This class represents whether the content is opened in a new tab
 *
 * @category   System
 * @package    Content
 */
class ContentOpenInNewTabStatus implements ContentOpenInNewTabStatusInterface
{
    /**
     * Open in a new tab status
     *
     * @var bool
     */
    protected $openInNewTab;
    
    
    /**
     * ContentOpenInNewTabStatus constructor
     *
     * @param bool $openInNewTab Whether the content is opened in a new tab
     */
    public function __construct(bool $openInNewTab)
    {
        $this->openInNewTab = $openInNewTab;
    }
    
    
    /**
     * Return whether the content is opened in a new tab
     *
     * @return bool
     */
    public function opensInNewTab(): bool
    {
        return $this->openInNewTab;
    }
}